-- mod-version:3
-- Support for the intel syntax x86-64 assembly
-- Simply add it to lite-xl's plugins folder (located somewhere at home/.config/lite-xl/plugins)
-- https://github.com/DMClVG

local syntax = require "core.syntax"

syntax.add {
  name = "x86 Assembly",
  files = { "%.asm$", "%.[sS]$" },
  comment = ";",
  patterns = {
    { pattern = ";.-\n", type = "comment" },
    { pattern = { '"', '"', '\\' }, type = "string" },
    { pattern = { "'", "'", '\\' }, type = "string" },
    { pattern = "0[bB][0-1]+%W", type = "number" },
    { pattern = "[0-1]+[bB]%W", type = "number" },
    { pattern = "0[xX]%x+", type = "number" },
    { pattern = "%x+[hH]%W", type = "number" },
    { pattern = "%d+[%d%.eE]*f?", type = "number" },
    { pattern = "%.?%d+f?", type = "number" },
    { pattern = "%%+[%a_][%w_]*", type = "keyword" },
    { pattern = "[%+%-=/%*%^%%<>!~|&%$]", type = "operator" },
    { pattern = "[%a_][%w_]*:%W", type = "function" },
    { pattern = "[%a_][%w_]*", type = "symbol" },
    { pattern = "%.%.%a+", type = "normal" }
  },
  symbols = {
    -- Registers
    ["rax"] = "literal",
    ["eax"] = "literal",
    ["ax"] = "literal",
    ["ah"] = "literal",
    ["al"] = "literal",
    ["rbx"] = "literal",
    ["ebx"] = "literal",
    ["bx"] = "literal",
    ["bh"] = "literal",
    ["bl"] = "literal",
    ["rcx"] = "literal",
    ["ecx"] = "literal",
    ["cx"] = "literal",
    ["ch"] = "literal",
    ["cl"] = "literal",
    ["rdx"] = "literal",
    ["edx"] = "literal",
    ["dx"] = "literal",
    ["dh"] = "literal",
    ["dl"] = "literal",
    ["rbp"] = "literal",
    ["ebp"] = "literal",
    ["bp"] = "literal",
    ["bpl"] = "literal",
    ["rsi"] = "literal",
    ["esi"] = "literal",
    ["si"] = "literal",
    ["sil"] = "literal",
    ["rdi"] = "literal",
    ["edi"] = "literal",
    ["di"] = "literal",
    ["dil"] = "literal",
    ["rip"] = "literal",
    ["eip"] = "literal",
    ["ip"] = "literal",
    ["rsp"] = "literal",
    ["esp"] = "literal",
    ["sp"] = "literal",
    ["spl"] = "literal",
    ["cs"] = "literal",
    ["ds"] = "literal",
    ["es"] = "literal",
    ["fs"] = "literal",
    ["gs"] = "literal",
    ["ss"] = "literal",
    ["cr0"] = "literal",
    ["cr1"] = "literal",
    ["cr2"] = "literal",
    ["cr3"] = "literal",
    ["cr4"] = "literal",
    ["dr0"] = "literal",
    ["dr1"] = "literal",
    ["dr2"] = "literal",
    ["dr3"] = "literal",
    ["dr6"] = "literal",
    ["dr7"] = "literal",
    ["st"] = "literal",
    ["st0"] = "literal",
    ["st1"] = "literal",
    ["st2"] = "literal",
    ["st3"] = "literal",
    ["st4"] = "literal",
    ["st5"] = "literal",
    ["st6"] = "literal",
    ["st7"] = "literal",
    ["mm0"] = "literal",
    ["mm1"] = "literal",
    ["mm2"] = "literal",
    ["mm3"] = "literal",
    ["mm4"] = "literal",
    ["mm5"] = "literal",
    ["mm6"] = "literal",
    ["mm7"] = "literal",
    ["xmm0"] = "literal",
    ["xmm1"] = "literal",
    ["xmm2"] = "literal",
    ["xmm3"] = "literal",
    ["xmm4"] = "literal",
    ["xmm5"] = "literal",
    ["xmm6"] = "literal",
    ["xmm7"] = "literal",
    ["xmm8"] = "literal",
    ["xmm9"] = "literal",
    ["xmm10"] = "literal",
    ["xmm11"] = "literal",
    ["xmm12"] = "literal",
    ["xmm13"] = "literal",
    ["xmm14"] = "literal",
    ["xmm15"] = "literal",
    ["xmm16"] = "literal",
    ["xmm17"] = "literal",
    ["xmm18"] = "literal",
    ["xmm19"] = "literal",
    ["xmm20"] = "literal",
    ["xmm21"] = "literal",
    ["xmm22"] = "literal",
    ["xmm23"] = "literal",
    ["xmm24"] = "literal",
    ["xmm25"] = "literal",
    ["xmm26"] = "literal",
    ["xmm27"] = "literal",
    ["xmm28"] = "literal",
    ["xmm29"] = "literal",
    ["xmm30"] = "literal",
    ["xmm31"] = "literal",
    ["ymm0"] = "literal",
    ["ymm1"] = "literal",
    ["ymm2"] = "literal",
    ["ymm3"] = "literal",
    ["ymm4"] = "literal",
    ["ymm5"] = "literal",
    ["ymm6"] = "literal",
    ["ymm7"] = "literal",
    ["ymm8"] = "literal",
    ["ymm9"] = "literal",
    ["ymm10"] = "literal",
    ["ymm11"] = "literal",
    ["ymm12"] = "literal",
    ["ymm13"] = "literal",
    ["ymm14"] = "literal",
    ["ymm15"] = "literal",
    ["ymm16"] = "literal",
    ["ymm17"] = "literal",
    ["ymm18"] = "literal",
    ["ymm19"] = "literal",
    ["ymm20"] = "literal",
    ["ymm21"] = "literal",
    ["ymm22"] = "literal",
    ["ymm23"] = "literal",
    ["ymm24"] = "literal",
    ["ymm25"] = "literal",
    ["ymm26"] = "literal",
    ["ymm27"] = "literal",
    ["ymm28"] = "literal",
    ["ymm29"] = "literal",
    ["ymm30"] = "literal",
    ["ymm31"] = "literal",
    ["zmm0"] = "literal",
    ["zmm1"] = "literal",
    ["zmm2"] = "literal",
    ["zmm3"] = "literal",
    ["zmm4"] = "literal",
    ["zmm5"] = "literal",
    ["zmm6"] = "literal",
    ["zmm7"] = "literal",
    ["zmm8"] = "literal",
    ["zmm9"] = "literal",
    ["zmm10"] = "literal",
    ["zmm11"] = "literal",
    ["zmm12"] = "literal",
    ["zmm13"] = "literal",
    ["zmm14"] = "literal",
    ["zmm15"] = "literal",
    ["zmm16"] = "literal",
    ["zmm17"] = "literal",
    ["zmm18"] = "literal",
    ["zmm19"] = "literal",
    ["zmm20"] = "literal",
    ["zmm21"] = "literal",
    ["zmm22"] = "literal",
    ["zmm23"] = "literal",
    ["zmm24"] = "literal",
    ["zmm25"] = "literal",
    ["zmm26"] = "literal",
    ["zmm27"] = "literal",
    ["zmm28"] = "literal",
    ["zmm29"] = "literal",
    ["zmm30"] = "literal",
    ["zmm31"] = "literal",
    ["r8"] = "literal",
    ["r8d"] = "literal",
    ["r8w"] = "literal",
    ["r8b"] = "literal",
    ["r9"] = "literal",
    ["r9d"] = "literal",
    ["r9w"] = "literal",
    ["r9b"] = "literal",
    ["r10"] = "literal",
    ["r10d"] = "literal",
    ["r10w"] = "literal",
    ["r10b"] = "literal",
    ["r11"] = "literal",
    ["r11d"] = "literal",
    ["r11w"] = "literal",
    ["r11b"] = "literal",
    ["r12"] = "literal",
    ["r12d"] = "literal",
    ["r12w"] = "literal",
    ["r12b"] = "literal",
    ["r13"] = "literal",
    ["r13d"] = "literal",
    ["r13w"] = "literal",
    ["r13b"] = "literal",
    ["r14"] = "literal",
    ["r14d"] = "literal",
    ["r14w"] = "literal",
    ["r14b"] = "literal",
    ["r15"] = "literal",
    ["r15d"] = "literal",
    ["r15w"] = "literal",
    ["r15b"] = "literal",

    -- Instructions
    ["aaa"] = "keyword",
    ["aad"] = "keyword",
    ["aam"] = "keyword",
    ["aas"] = "keyword",
    ["adc"] = "keyword",
    ["adcx"] = "keyword",
    ["add"] = "keyword",
    ["addpd"] = "keyword",
    ["addps"] = "keyword",
    ["addsd"] = "keyword",
    ["addss"] = "keyword",
    ["addsubpd"] = "keyword",
    ["addsubps"] = "keyword",
    ["adox"] = "keyword",
    ["aesdec"] = "keyword",
    ["aesdeclast"] = "keyword",
    ["aesenc"] = "keyword",
    ["aesenclast"] = "keyword",
    ["aesimc"] = "keyword",
    ["aeskeygenassist"] = "keyword",
    ["and"] = "keyword",
    ["andn"] = "keyword",
    ["andnpd"] = "keyword",
    ["andnps"] = "keyword",
    ["andpd"] = "keyword",
    ["andps"] = "keyword",
    ["arpl"] = "keyword",
    ["bb0_reset"] = "keyword",
    ["bb1_reset"] = "keyword",
    ["bextr"] = "keyword",
    ["blcfill"] = "keyword",
    ["blci"] = "keyword",
    ["blcic"] = "keyword",
    ["blcmsk"] = "keyword",
    ["blcs"] = "keyword",
    ["blendpd"] = "keyword",
    ["blendps"] = "keyword",
    ["blendvpd"] = "keyword",
    ["blendvps"] = "keyword",
    ["blsfill"] = "keyword",
    ["blsi"] = "keyword",
    ["blsic"] = "keyword",
    ["blsmsk"] = "keyword",
    ["blsr"] = "keyword",
    ["bndcl"] = "keyword",
    ["bndcn"] = "keyword",
    ["bndcu"] = "keyword",
    ["bndldx"] = "keyword",
    ["bndmk"] = "keyword",
    ["bndmov"] = "keyword",
    ["bndstx"] = "keyword",
    ["bound"] = "keyword",
    ["bsf"] = "keyword",
    ["bsr"] = "keyword",
    ["bswap"] = "keyword",
    ["bt"] = "keyword",
    ["btc"] = "keyword",
    ["btr"] = "keyword",
    ["bts"] = "keyword",
    ["bzhi"] = "keyword",
    ["call"] = "keyword",
    ["cbw"] = "keyword",
    ["cdq"] = "keyword",
    ["cdqe"] = "keyword",
    ["clac"] = "keyword",
    ["clc"] = "keyword",
    ["cld"] = "keyword",
    ["clflush"] = "keyword",
    ["clflushopt"] = "keyword",
    ["clgi"] = "keyword",
    ["cli"] = "keyword",
    ["clts"] = "keyword",
    ["clwb"] = "keyword",
    ["clzero"] = "keyword",
    ["cmc"] = "keyword",
    ["cmova"] = "keyword",
    ["cmovae"] = "keyword",
    ["cmovb"] = "keyword",
    ["cmovbe"] = "keyword",
    ["cmovc"] = "keyword",
    ["cmove"] = "keyword",
    ["cmovg"] = "keyword",
    ["cmovge"] = "keyword",
    ["cmovl"] = "keyword",
    ["cmovle"] = "keyword",
    ["cmovna"] = "keyword",
    ["cmovnae"] = "keyword",
    ["cmovnb"] = "keyword",
    ["cmovnbe"] = "keyword",
    ["cmovnc"] = "keyword",
    ["cmovne"] = "keyword",
    ["cmovng"] = "keyword",
    ["cmovnge"] = "keyword",
    ["cmovnl"] = "keyword",
    ["cmovnle"] = "keyword",
    ["cmovno"] = "keyword",
    ["cmovnp"] = "keyword",
    ["cmovns"] = "keyword",
    ["cmovnz"] = "keyword",
    ["cmovo"] = "keyword",
    ["cmovp"] = "keyword",
    ["cmovpe"] = "keyword",
    ["cmovpo"] = "keyword",
    ["cmovs"] = "keyword",
    ["cmovz"] = "keyword",
    ["cmp"] = "keyword",
    ["cmpeqpd"] = "keyword",
    ["cmpeqps"] = "keyword",
    ["cmpeqsd"] = "keyword",
    ["cmpeqss"] = "keyword",
    ["cmplepd"] = "keyword",
    ["cmpleps"] = "keyword",
    ["cmplesd"] = "keyword",
    ["cmpless"] = "keyword",
    ["cmpltpd"] = "keyword",
    ["cmpltps"] = "keyword",
    ["cmpltsd"] = "keyword",
    ["cmpltss"] = "keyword",
    ["cmpneqpd"] = "keyword",
    ["cmpneqps"] = "keyword",
    ["cmpneqsd"] = "keyword",
    ["cmpneqss"] = "keyword",
    ["cmpnlepd"] = "keyword",
    ["cmpnleps"] = "keyword",
    ["cmpnlesd"] = "keyword",
    ["cmpnless"] = "keyword",
    ["cmpnltpd"] = "keyword",
    ["cmpnltps"] = "keyword",
    ["cmpnltsd"] = "keyword",
    ["cmpnltss"] = "keyword",
    ["cmpordpd"] = "keyword",
    ["cmpordps"] = "keyword",
    ["cmpordsd"] = "keyword",
    ["cmpordss"] = "keyword",
    ["cmppd"] = "keyword",
    ["cmpps"] = "keyword",
    ["cmps"] = "keyword",
    ["cmpsb"] = "keyword",
    ["cmpsd"] = "keyword",
    ["cmpsq"] = "keyword",
    ["cmpss"] = "keyword",
    ["cmpsw"] = "keyword",
    ["cmpunordpd"] = "keyword",
    ["cmpunordps"] = "keyword",
    ["cmpunordsd"] = "keyword",
    ["cmpunordss"] = "keyword",
    ["cmpxchg"] = "keyword",
    ["cmpxchg16b"] = "keyword",
    ["cmpxchg486"] = "keyword",
    ["cmpxchg8b"] = "keyword",
    ["comisd"] = "keyword",
    ["comiss"] = "keyword",
    ["cpu_read"] = "keyword",
    ["cpu_write"] = "keyword",
    ["cpuid"] = "keyword",
    ["cqo"] = "keyword",
    ["crc32"] = "keyword",
    ["cvtdq2pd"] = "keyword",
    ["cvtdq2ps"] = "keyword",
    ["cvtpd2dq"] = "keyword",
    ["cvtpd2pi"] = "keyword",
    ["cvtpd2ps"] = "keyword",
    ["cvtpi2pd"] = "keyword",
    ["cvtpi2ps"] = "keyword",
    ["cvtps2dq"] = "keyword",
    ["cvtps2pd"] = "keyword",
    ["cvtps2pi"] = "keyword",
    ["cvtsd2si"] = "keyword",
    ["cvtsd2ss"] = "keyword",
    ["cvtsi2sd"] = "keyword",
    ["cvtsi2ss"] = "keyword",
    ["cvtss2sd"] = "keyword",
    ["cvtss2si"] = "keyword",
    ["cvttpd2dq"] = "keyword",
    ["cvttpd2pi"] = "keyword",
    ["cvttps2dq"] = "keyword",
    ["cvttps2pi"] = "keyword",
    ["cvttsd2si"] = "keyword",
    ["cvttss2si"] = "keyword",
    ["cwd"] = "keyword",
    ["cwde"] = "keyword",
    ["daa"] = "keyword",
    ["das"] = "keyword",
    ["dec"] = "keyword",
    ["div"] = "keyword",
    ["divpd"] = "keyword",
    ["divps"] = "keyword",
    ["divsd"] = "keyword",
    ["divss"] = "keyword",
    ["dmint"] = "keyword",
    ["dppd"] = "keyword",
    ["dpps"] = "keyword",
    ["emms"] = "keyword",
    ["enter"] = "keyword",
    ["extractps"] = "keyword",
    ["extrq"] = "keyword",
    ["f2xm1"] = "keyword",
    ["fabs"] = "keyword",
    ["fadd"] = "keyword",
    ["faddp"] = "keyword",
    ["fbld"] = "keyword",
    ["fbstp"] = "keyword",
    ["fchs"] = "keyword",
    ["fclex"] = "keyword",
    ["fcmovb"] = "keyword",
    ["fcmovbe"] = "keyword",
    ["fcmove"] = "keyword",
    ["fcmovnb"] = "keyword",
    ["fcmovnbe"] = "keyword",
    ["fcmovne"] = "keyword",
    ["fcmovnu"] = "keyword",
    ["fcmovu"] = "keyword",
    ["fcom"] = "keyword",
    ["fcomi"] = "keyword",
    ["fcomip"] = "keyword",
    ["fcomp"] = "keyword",
    ["fcompp"] = "keyword",
    ["fcos"] = "keyword",
    ["fdecstp"] = "keyword",
    ["fdisi"] = "keyword",
    ["fdiv"] = "keyword",
    ["fdivp"] = "keyword",
    ["fdivr"] = "keyword",
    ["fdivrp"] = "keyword",
    ["femms"] = "keyword",
    ["feni"] = "keyword",
    ["ffree"] = "keyword",
    ["ffreep"] = "keyword",
    ["fiadd"] = "keyword",
    ["ficom"] = "keyword",
    ["ficomp"] = "keyword",
    ["fidiv"] = "keyword",
    ["fidivr"] = "keyword",
    ["fild"] = "keyword",
    ["fimul"] = "keyword",
    ["fincstp"] = "keyword",
    ["finit"] = "keyword",
    ["fist"] = "keyword",
    ["fistp"] = "keyword",
    ["fisttp"] = "keyword",
    ["fisub"] = "keyword",
    ["fisubr"] = "keyword",
    ["fld"] = "keyword",
    ["fld1"] = "keyword",
    ["fldcw"] = "keyword",
    ["fldenv"] = "keyword",
    ["fldl2e"] = "keyword",
    ["fldl2t"] = "keyword",
    ["fldlg2"] = "keyword",
    ["fldln2"] = "keyword",
    ["fldpi"] = "keyword",
    ["fldz"] = "keyword",
    ["fmul"] = "keyword",
    ["fmulp"] = "keyword",
    ["fnclex"] = "keyword",
    ["fndisi"] = "keyword",
    ["fneni"] = "keyword",
    ["fninit"] = "keyword",
    ["fnop"] = "keyword",
    ["fnsave"] = "keyword",
    ["fnstcw"] = "keyword",
    ["fnstenv"] = "keyword",
    ["fnstsw"] = "keyword",
    ["fnwait"] = "keyword",
    ["fpatan"] = "keyword",
    ["fprem"] = "keyword",
    ["fprem1"] = "keyword",
    ["fptan"] = "keyword",
    ["frndint"] = "keyword",
    ["frstor"] = "keyword",
    ["fsave"] = "keyword",
    ["fscale"] = "keyword",
    ["fsetpm"] = "keyword",
    ["fsin"] = "keyword",
    ["fsincos"] = "keyword",
    ["fsqrt"] = "keyword",
    ["fst"] = "keyword",
    ["fstcw"] = "keyword",
    ["fstenv"] = "keyword",
    ["fstp"] = "keyword",
    ["fstsw"] = "keyword",
    ["fsub"] = "keyword",
    ["fsubp"] = "keyword",
    ["fsubr"] = "keyword",
    ["fsubrp"] = "keyword",
    ["ftst"] = "keyword",
    ["fucom"] = "keyword",
    ["fucomi"] = "keyword",
    ["fucomip"] = "keyword",
    ["fucomp"] = "keyword",
    ["fucompp"] = "keyword",
    ["fwait"] = "keyword",
    ["fxam"] = "keyword",
    ["fxch"] = "keyword",
    ["fxrstor"] = "keyword",
    ["fxrstor64"] = "keyword",
    ["fxsave"] = "keyword",
    ["fxsave64"] = "keyword",
    ["fxtract"] = "keyword",
    ["fyl2x"] = "keyword",
    ["fyl2xp1"] = "keyword",
    ["getsec"] = "keyword",
    ["haddpd"] = "keyword",
    ["haddps"] = "keyword",
    ["hint_nop0"] = "keyword",
    ["hint_nop1"] = "keyword",
    ["hint_nop10"] = "keyword",
    ["hint_nop11"] = "keyword",
    ["hint_nop12"] = "keyword",
    ["hint_nop13"] = "keyword",
    ["hint_nop14"] = "keyword",
    ["hint_nop15"] = "keyword",
    ["hint_nop16"] = "keyword",
    ["hint_nop17"] = "keyword",
    ["hint_nop18"] = "keyword",
    ["hint_nop19"] = "keyword",
    ["hint_nop2"] = "keyword",
    ["hint_nop20"] = "keyword",
    ["hint_nop21"] = "keyword",
    ["hint_nop22"] = "keyword",
    ["hint_nop23"] = "keyword",
    ["hint_nop24"] = "keyword",
    ["hint_nop25"] = "keyword",
    ["hint_nop26"] = "keyword",
    ["hint_nop27"] = "keyword",
    ["hint_nop28"] = "keyword",
    ["hint_nop29"] = "keyword",
    ["hint_nop3"] = "keyword",
    ["hint_nop30"] = "keyword",
    ["hint_nop31"] = "keyword",
    ["hint_nop32"] = "keyword",
    ["hint_nop33"] = "keyword",
    ["hint_nop34"] = "keyword",
    ["hint_nop35"] = "keyword",
    ["hint_nop36"] = "keyword",
    ["hint_nop37"] = "keyword",
    ["hint_nop38"] = "keyword",
    ["hint_nop39"] = "keyword",
    ["hint_nop4"] = "keyword",
    ["hint_nop40"] = "keyword",
    ["hint_nop41"] = "keyword",
    ["hint_nop42"] = "keyword",
    ["hint_nop43"] = "keyword",
    ["hint_nop44"] = "keyword",
    ["hint_nop45"] = "keyword",
    ["hint_nop46"] = "keyword",
    ["hint_nop47"] = "keyword",
    ["hint_nop48"] = "keyword",
    ["hint_nop49"] = "keyword",
    ["hint_nop5"] = "keyword",
    ["hint_nop50"] = "keyword",
    ["hint_nop51"] = "keyword",
    ["hint_nop52"] = "keyword",
    ["hint_nop53"] = "keyword",
    ["hint_nop54"] = "keyword",
    ["hint_nop55"] = "keyword",
    ["hint_nop56"] = "keyword",
    ["hint_nop57"] = "keyword",
    ["hint_nop58"] = "keyword",
    ["hint_nop59"] = "keyword",
    ["hint_nop6"] = "keyword",
    ["hint_nop60"] = "keyword",
    ["hint_nop61"] = "keyword",
    ["hint_nop62"] = "keyword",
    ["hint_nop63"] = "keyword",
    ["hint_nop7"] = "keyword",
    ["hint_nop8"] = "keyword",
    ["hint_nop9"] = "keyword",
    ["hlt"] = "keyword",
    ["hsubpd"] = "keyword",
    ["hsubps"] = "keyword",
    ["ibts"] = "keyword",
    ["icebp"] = "keyword",
    ["idiv"] = "keyword",
    ["imul"] = "keyword",
    ["in"] = "keyword",
    ["inc"] = "keyword",
    ["ins"] = "keyword",
    ["insb"] = "keyword",
    ["insd"] = "keyword",
    ["insertps"] = "keyword",
    ["insertq"] = "keyword",
    ["insw"] = "keyword",
    ["int"] = "keyword",
    ["int01"] = "keyword",
    ["int03"] = "keyword",
    ["int1"] = "keyword",
    ["int3"] = "keyword",
    ["into"] = "keyword",
    ["invd"] = "keyword",
    ["invept"] = "keyword",
    ["invlpg"] = "keyword",
    ["invlpga"] = "keyword",
    ["invpcid"] = "keyword",
    ["invvpid"] = "keyword",
    ["iret"] = "keyword",
    ["iretd"] = "keyword",
    ["iretq"] = "keyword",
    ["iretw"] = "keyword",
    ["ja"] = "keyword",
    ["jae"] = "keyword",
    ["jb"] = "keyword",
    ["jbe"] = "keyword",
    ["jc"] = "keyword",
    ["jcc"] = "keyword",
    ["jcxz"] = "keyword",
    ["je"] = "keyword",
    ["jecxz"] = "keyword",
    ["jg"] = "keyword",
    ["jge"] = "keyword",
    ["jl"] = "keyword",
    ["jle"] = "keyword",
    ["jmp"] = "keyword",
    ["jmpe"] = "keyword",
    ["jna"] = "keyword",
    ["jnae"] = "keyword",
    ["jnb"] = "keyword",
    ["jnbe"] = "keyword",
    ["jnc"] = "keyword",
    ["jne"] = "keyword",
    ["jng"] = "keyword",
    ["jnge"] = "keyword",
    ["jnl"] = "keyword",
    ["jnle"] = "keyword",
    ["jno"] = "keyword",
    ["jnp"] = "keyword",
    ["jns"] = "keyword",
    ["jnz"] = "keyword",
    ["jo"] = "keyword",
    ["jp"] = "keyword",
    ["jpe"] = "keyword",
    ["jpo"] = "keyword",
    ["jrcxz"] = "keyword",
    ["js"] = "keyword",
    ["jz"] = "keyword",
    ["kaddb"] = "keyword",
    ["kaddd"] = "keyword",
    ["kaddq"] = "keyword",
    ["kaddw"] = "keyword",
    ["kandb"] = "keyword",
    ["kandd"] = "keyword",
    ["kandnb"] = "keyword",
    ["kandnd"] = "keyword",
    ["kandnq"] = "keyword",
    ["kandnw"] = "keyword",
    ["kandq"] = "keyword",
    ["kandw"] = "keyword",
    ["kmovb"] = "keyword",
    ["kmovd"] = "keyword",
    ["kmovq"] = "keyword",
    ["kmovw"] = "keyword",
    ["knotb"] = "keyword",
    ["knotd"] = "keyword",
    ["knotq"] = "keyword",
    ["knotw"] = "keyword",
    ["korb"] = "keyword",
    ["kord"] = "keyword",
    ["korq"] = "keyword",
    ["kortestb"] = "keyword",
    ["kortestd"] = "keyword",
    ["kortestq"] = "keyword",
    ["kortestw"] = "keyword",
    ["korw"] = "keyword",
    ["kshiftlb"] = "keyword",
    ["kshiftld"] = "keyword",
    ["kshiftlq"] = "keyword",
    ["kshiftlw"] = "keyword",
    ["kshiftrb"] = "keyword",
    ["kshiftrd"] = "keyword",
    ["kshiftrq"] = "keyword",
    ["kshiftrw"] = "keyword",
    ["ktestb"] = "keyword",
    ["ktestd"] = "keyword",
    ["ktestq"] = "keyword",
    ["ktestw"] = "keyword",
    ["kunpckbw"] = "keyword",
    ["kunpckdq"] = "keyword",
    ["kunpckwd"] = "keyword",
    ["kxnorb"] = "keyword",
    ["kxnord"] = "keyword",
    ["kxnorq"] = "keyword",
    ["kxnorw"] = "keyword",
    ["kxorb"] = "keyword",
    ["kxord"] = "keyword",
    ["kxorq"] = "keyword",
    ["kxorw"] = "keyword",
    ["lahf"] = "keyword",
    ["lar"] = "keyword",
    ["lddqu"] = "keyword",
    ["ldmxcsr"] = "keyword",
    ["lds"] = "keyword",
    ["lea"] = "keyword",
    ["leave"] = "keyword",
    ["les"] = "keyword",
    ["lfence"] = "keyword",
    ["lfs"] = "keyword",
    ["lgdt"] = "keyword",
    ["lgs"] = "keyword",
    ["lidt"] = "keyword",
    ["lldt"] = "keyword",
    ["llwpcb"] = "keyword",
    ["lmsw"] = "keyword",
    ["loadall"] = "keyword",
    ["loadall286"] = "keyword",
    ["lock"] = "keyword",
    ["lods"] = "keyword",
    ["lodsb"] = "keyword",
    ["lodsd"] = "keyword",
    ["lodsq"] = "keyword",
    ["lodsw"] = "keyword",
    ["loop"] = "keyword",
    ["loope"] = "keyword",
    ["loopne"] = "keyword",
    ["loopnz"] = "keyword",
    ["loopz"] = "keyword",
    ["lsl"] = "keyword",
    ["lss"] = "keyword",
    ["ltr"] = "keyword",
    ["lwpins"] = "keyword",
    ["lwpval"] = "keyword",
    ["lzcnt"] = "keyword",
    ["maskmovdqu"] = "keyword",
    ["maskmovq"] = "keyword",
    ["maxpd"] = "keyword",
    ["maxps"] = "keyword",
    ["maxsd"] = "keyword",
    ["maxss"] = "keyword",
    ["mfence"] = "keyword",
    ["minpd"] = "keyword",
    ["minps"] = "keyword",
    ["minsd"] = "keyword",
    ["minss"] = "keyword",
    ["monitor"] = "keyword",
    ["monitorx"] = "keyword",
    ["montmul"] = "keyword",
    ["mov"] = "keyword",
    ["movapd"] = "keyword",
    ["movaps"] = "keyword",
    ["movbe"] = "keyword",
    ["movd"] = "keyword",
    ["movddup"] = "keyword",
    ["movdq2q"] = "keyword",
    ["movdqa"] = "keyword",
    ["movdqu"] = "keyword",
    ["movhlps"] = "keyword",
    ["movhpd"] = "keyword",
    ["movhps"] = "keyword",
    ["movlhps"] = "keyword",
    ["movlpd"] = "keyword",
    ["movlps"] = "keyword",
    ["movmskpd"] = "keyword",
    ["movmskps"] = "keyword",
    ["movntdq"] = "keyword",
    ["movntdqa"] = "keyword",
    ["movnti"] = "keyword",
    ["movntpd"] = "keyword",
    ["movntps"] = "keyword",
    ["movntq"] = "keyword",
    ["movntsd"] = "keyword",
    ["movntss"] = "keyword",
    ["movq"] = "keyword",
    ["movq2dq"] = "keyword",
    ["movs"] = "keyword",
    ["movsb"] = "keyword",
    ["movsd"] = "keyword",
    ["movshdup"] = "keyword",
    ["movsldup"] = "keyword",
    ["movsq"] = "keyword",
    ["movss"] = "keyword",
    ["movsw"] = "keyword",
    ["movsx"] = "keyword",
    ["movsxd"] = "keyword",
    ["movupd"] = "keyword",
    ["movups"] = "keyword",
    ["movzx"] = "keyword",
    ["mpsadbw"] = "keyword",
    ["mul"] = "keyword",
    ["mulpd"] = "keyword",
    ["mulps"] = "keyword",
    ["mulsd"] = "keyword",
    ["mulss"] = "keyword",
    ["mulx"] = "keyword",
    ["mwait"] = "keyword",
    ["mwaitx"] = "keyword",
    ["neg"] = "keyword",
    ["nop"] = "keyword",
    ["not"] = "keyword",
    ["or"] = "keyword",
    ["orpd"] = "keyword",
    ["orps"] = "keyword",
    ["out"] = "keyword",
    ["outs"] = "keyword",
    ["outsb"] = "keyword",
    ["outsd"] = "keyword",
    ["outsw"] = "keyword",
    ["pabsb"] = "keyword",
    ["pabsd"] = "keyword",
    ["pabsw"] = "keyword",
    ["packssdw"] = "keyword",
    ["packsswb"] = "keyword",
    ["packusdw"] = "keyword",
    ["packuswb"] = "keyword",
    ["paddb"] = "keyword",
    ["paddd"] = "keyword",
    ["paddq"] = "keyword",
    ["paddsb"] = "keyword",
    ["paddsiw"] = "keyword",
    ["paddsw"] = "keyword",
    ["paddusb"] = "keyword",
    ["paddusw"] = "keyword",
    ["paddw"] = "keyword",
    ["palignr"] = "keyword",
    ["pand"] = "keyword",
    ["pandn"] = "keyword",
    ["pause"] = "keyword",
    ["paveb"] = "keyword",
    ["pavgb"] = "keyword",
    ["pavgusb"] = "keyword",
    ["pavgw"] = "keyword",
    ["pblendvb"] = "keyword",
    ["pblendw"] = "keyword",
    ["pclmulhqhqdq"] = "keyword",
    ["pclmulhqlqdq"] = "keyword",
    ["pclmullqhqdq"] = "keyword",
    ["pclmullqlqdq"] = "keyword",
    ["pclmulqdq"] = "keyword",
    ["pcmpeqb"] = "keyword",
    ["pcmpeqd"] = "keyword",
    ["pcmpeqq"] = "keyword",
    ["pcmpeqw"] = "keyword",
    ["pcmpestri"] = "keyword",
    ["pcmpestrm"] = "keyword",
    ["pcmpgtb"] = "keyword",
    ["pcmpgtd"] = "keyword",
    ["pcmpgtq"] = "keyword",
    ["pcmpgtw"] = "keyword",
    ["pcmpistri"] = "keyword",
    ["pcmpistrm"] = "keyword",
    ["pcommit"] = "keyword",
    ["pdep"] = "keyword",
    ["pdistib"] = "keyword",
    ["pext"] = "keyword",
    ["pextrb"] = "keyword",
    ["pextrd"] = "keyword",
    ["pextrq"] = "keyword",
    ["pextrw"] = "keyword",
    ["pf2id"] = "keyword",
    ["pf2iw"] = "keyword",
    ["pfacc"] = "keyword",
    ["pfadd"] = "keyword",
    ["pfcmpeq"] = "keyword",
    ["pfcmpge"] = "keyword",
    ["pfcmpgt"] = "keyword",
    ["pfmax"] = "keyword",
    ["pfmin"] = "keyword",
    ["pfmul"] = "keyword",
    ["pfnacc"] = "keyword",
    ["pfpnacc"] = "keyword",
    ["pfrcp"] = "keyword",
    ["pfrcpit1"] = "keyword",
    ["pfrcpit2"] = "keyword",
    ["pfrcpv"] = "keyword",
    ["pfrsqit1"] = "keyword",
    ["pfrsqrt"] = "keyword",
    ["pfrsqrtv"] = "keyword",
    ["pfsub"] = "keyword",
    ["pfsubr"] = "keyword",
    ["phaddd"] = "keyword",
    ["phaddsw"] = "keyword",
    ["phaddw"] = "keyword",
    ["phminposuw"] = "keyword",
    ["phsubd"] = "keyword",
    ["phsubsw"] = "keyword",
    ["phsubw"] = "keyword",
    ["pi2fd"] = "keyword",
    ["pi2fw"] = "keyword",
    ["pinsrb"] = "keyword",
    ["pinsrd"] = "keyword",
    ["pinsrq"] = "keyword",
    ["pinsrw"] = "keyword",
    ["pmachriw"] = "keyword",
    ["pmaddubsw"] = "keyword",
    ["pmaddwd"] = "keyword",
    ["pmagw"] = "keyword",
    ["pmaxsb"] = "keyword",
    ["pmaxsd"] = "keyword",
    ["pmaxsw"] = "keyword",
    ["pmaxub"] = "keyword",
    ["pmaxud"] = "keyword",
    ["pmaxuw"] = "keyword",
    ["pminsb"] = "keyword",
    ["pminsd"] = "keyword",
    ["pminsw"] = "keyword",
    ["pminub"] = "keyword",
    ["pminud"] = "keyword",
    ["pminuw"] = "keyword",
    ["pmovmskb"] = "keyword",
    ["pmovsxbd"] = "keyword",
    ["pmovsxbq"] = "keyword",
    ["pmovsxbw"] = "keyword",
    ["pmovsxdq"] = "keyword",
    ["pmovsxwd"] = "keyword",
    ["pmovsxwq"] = "keyword",
    ["pmovzxbd"] = "keyword",
    ["pmovzxbq"] = "keyword",
    ["pmovzxbw"] = "keyword",
    ["pmovzxdq"] = "keyword",
    ["pmovzxwd"] = "keyword",
    ["pmovzxwq"] = "keyword",
    ["pmuldq"] = "keyword",
    ["pmulhriw"] = "keyword",
    ["pmulhrsw"] = "keyword",
    ["pmulhrw"] = "keyword",
    ["pmulhrwa"] = "keyword",
    ["pmulhrwc"] = "keyword",
    ["pmulhuw"] = "keyword",
    ["pmulhw"] = "keyword",
    ["pmulld"] = "keyword",
    ["pmullw"] = "keyword",
    ["pmuludq"] = "keyword",
    ["pmvgezb"] = "keyword",
    ["pmvlzb"] = "keyword",
    ["pmvnzb"] = "keyword",
    ["pmvzb"] = "keyword",
    ["pop"] = "keyword",
    ["popa"] = "keyword",
    ["popad"] = "keyword",
    ["popaw"] = "keyword",
    ["popcnt"] = "keyword",
    ["popf"] = "keyword",
    ["popfd"] = "keyword",
    ["popfq"] = "keyword",
    ["popfw"] = "keyword",
    ["por"] = "keyword",
    ["prefetch"] = "keyword",
    ["prefetchnta"] = "keyword",
    ["prefetcht0"] = "keyword",
    ["prefetcht1"] = "keyword",
    ["prefetcht2"] = "keyword",
    ["prefetchw"] = "keyword",
    ["prefetchwt1"] = "keyword",
    ["psadbw"] = "keyword",
    ["pshufb"] = "keyword",
    ["pshufd"] = "keyword",
    ["pshufhw"] = "keyword",
    ["pshuflw"] = "keyword",
    ["pshufw"] = "keyword",
    ["psignb"] = "keyword",
    ["psignd"] = "keyword",
    ["psignw"] = "keyword",
    ["pslld"] = "keyword",
    ["pslldq"] = "keyword",
    ["psllq"] = "keyword",
    ["psllw"] = "keyword",
    ["psrad"] = "keyword",
    ["psraw"] = "keyword",
    ["psrld"] = "keyword",
    ["psrldq"] = "keyword",
    ["psrlq"] = "keyword",
    ["psrlw"] = "keyword",
    ["psubb"] = "keyword",
    ["psubd"] = "keyword",
    ["psubq"] = "keyword",
    ["psubsb"] = "keyword",
    ["psubsiw"] = "keyword",
    ["psubsw"] = "keyword",
    ["psubusb"] = "keyword",
    ["psubusw"] = "keyword",
    ["psubw"] = "keyword",
    ["pswapd"] = "keyword",
    ["ptest"] = "keyword",
    ["punpckhbw"] = "keyword",
    ["punpckhdq"] = "keyword",
    ["punpckhqdq"] = "keyword",
    ["punpckhwd"] = "keyword",
    ["punpcklbw"] = "keyword",
    ["punpckldq"] = "keyword",
    ["punpcklqdq"] = "keyword",
    ["punpcklwd"] = "keyword",
    ["push"] = "keyword",
    ["pusha"] = "keyword",
    ["pushad"] = "keyword",
    ["pushaw"] = "keyword",
    ["pushf"] = "keyword",
    ["pushfd"] = "keyword",
    ["pushfq"] = "keyword",
    ["pushfw"] = "keyword",
    ["pxor"] = "keyword",
    ["rcl"] = "keyword",
    ["rcpps"] = "keyword",
    ["rcpss"] = "keyword",
    ["rcr"] = "keyword",
    ["rdfsbase"] = "keyword",
    ["rdgsbase"] = "keyword",
    ["rdm"] = "keyword",
    ["rdmsr"] = "keyword",
    ["rdpid"] = "keyword",
    ["rdpkru"] = "keyword",
    ["rdpmc"] = "keyword",
    ["rdrand"] = "keyword",
    ["rdseed"] = "keyword",
    ["rdshr"] = "keyword",
    ["rdtsc"] = "keyword",
    ["rdtscp"] = "keyword",
    ["rep"] = "keyword",
    ["repe"] = "keyword",
    ["repne"] = "keyword",
    ["repnz"] = "keyword",
    ["repz"] = "keyword",
    ["ret"] = "keyword",
    ["retf"] = "keyword",
    ["retn"] = "keyword",
    ["rol"] = "keyword",
    ["ror"] = "keyword",
    ["rorx"] = "keyword",
    ["roundpd"] = "keyword",
    ["roundps"] = "keyword",
    ["roundsd"] = "keyword",
    ["roundss"] = "keyword",
    ["roxr"] = "keyword",
    ["rsdc"] = "keyword",
    ["rsldt"] = "keyword",
    ["rsm"] = "keyword",
    ["rsqrtps"] = "keyword",
    ["rsqrtss"] = "keyword",
    ["rsts"] = "keyword",
    ["sahf"] = "keyword",
    ["sal"] = "keyword",
    ["salc"] = "keyword",
    ["sar"] = "keyword",
    ["sarx"] = "keyword",
    ["sbb"] = "keyword",
    ["scas"] = "keyword",
    ["scasb"] = "keyword",
    ["scasd"] = "keyword",
    ["scasq"] = "keyword",
    ["scasw"] = "keyword",
    ["seta"] = "keyword",
    ["setae"] = "keyword",
    ["setb"] = "keyword",
    ["setbe"] = "keyword",
    ["setc"] = "keyword",
    ["sete"] = "keyword",
    ["setg"] = "keyword",
    ["setge"] = "keyword",
    ["setl"] = "keyword",
    ["setle"] = "keyword",
    ["setna"] = "keyword",
    ["setnae"] = "keyword",
    ["setnb"] = "keyword",
    ["setnbe"] = "keyword",
    ["setnc"] = "keyword",
    ["setne"] = "keyword",
    ["setng"] = "keyword",
    ["setnge"] = "keyword",
    ["setnl"] = "keyword",
    ["setnle"] = "keyword",
    ["setno"] = "keyword",
    ["setnp"] = "keyword",
    ["setns"] = "keyword",
    ["setnz"] = "keyword",
    ["seto"] = "keyword",
    ["setp"] = "keyword",
    ["setpe"] = "keyword",
    ["setpo"] = "keyword",
    ["sets"] = "keyword",
    ["setz"] = "keyword",
    ["sfence"] = "keyword",
    ["sgdt"] = "keyword",
    ["shl"] = "keyword",
    ["shld"] = "keyword",
    ["shlx"] = "keyword",
    ["shr"] = "keyword",
    ["shrd"] = "keyword",
    ["shrx"] = "keyword",
    ["shufpd"] = "keyword",
    ["shufps"] = "keyword",
    ["sidt"] = "keyword",
    ["skinit"] = "keyword",
    ["sldt"] = "keyword",
    ["slwpcb"] = "keyword",
    ["smi"] = "keyword",
    ["smint"] = "keyword",
    ["smintold"] = "keyword",
    ["smsw"] = "keyword",
    ["sqrtpd"] = "keyword",
    ["sqrtps"] = "keyword",
    ["sqrtsd"] = "keyword",
    ["sqrtss"] = "keyword",
    ["stac"] = "keyword",
    ["stc"] = "keyword",
    ["std"] = "keyword",
    ["stgi"] = "keyword",
    ["sti"] = "keyword",
    ["stmxcsr"] = "keyword",
    ["stos"] = "keyword",
    ["stosb"] = "keyword",
    ["stosd"] = "keyword",
    ["stosq"] = "keyword",
    ["stosw"] = "keyword",
    ["str"] = "keyword",
    ["sub"] = "keyword",
    ["subpd"] = "keyword",
    ["subps"] = "keyword",
    ["subsd"] = "keyword",
    ["subss"] = "keyword",
    ["svdc"] = "keyword",
    ["svldt"] = "keyword",
    ["svts"] = "keyword",
    ["swapgs"] = "keyword",
    ["syscall"] = "keyword",
    ["sysenter"] = "keyword",
    ["sysexit"] = "keyword",
    ["sysret"] = "keyword",
    ["t1mskc"] = "keyword",
    ["test"] = "keyword",
    ["tzcnt"] = "keyword",
    ["tzmsk"] = "keyword",
    ["ucomisd"] = "keyword",
    ["ucomiss"] = "keyword",
    ["ud0"] = "keyword",
    ["ud1"] = "keyword",
    ["ud2"] = "keyword",
    ["ud2a"] = "keyword",
    ["ud2b"] = "keyword",
    ["umov"] = "keyword",
    ["unpckhpd"] = "keyword",
    ["unpckhps"] = "keyword",
    ["unpcklpd"] = "keyword",
    ["unpcklps"] = "keyword",
    ["vaddpd"] = "keyword",
    ["vaddps"] = "keyword",
    ["vaddsd"] = "keyword",
    ["vaddss"] = "keyword",
    ["vaddsubpd"] = "keyword",
    ["vaddsubps"] = "keyword",
    ["vaesdec"] = "keyword",
    ["vaesdeclast"] = "keyword",
    ["vaesenc"] = "keyword",
    ["vaesenclast"] = "keyword",
    ["vaesimc"] = "keyword",
    ["vaeskeygenassist"] = "keyword",
    ["valignd"] = "keyword",
    ["valignq"] = "keyword",
    ["vandnpd"] = "keyword",
    ["vandnps"] = "keyword",
    ["vandpd"] = "keyword",
    ["vandps"] = "keyword",
    ["vblendmpd"] = "keyword",
    ["vblendmps"] = "keyword",
    ["vblendpd"] = "keyword",
    ["vblendps"] = "keyword",
    ["vblendvpd"] = "keyword",
    ["vblendvps"] = "keyword",
    ["vbroadcastb"] = "keyword",
    ["vbroadcastd"] = "keyword",
    ["vbroadcastf128"] = "keyword",
    ["vbroadcastf32x2"] = "keyword",
    ["vbroadcastf32x4"] = "keyword",
    ["vbroadcastf32x8"] = "keyword",
    ["vbroadcastf64x2"] = "keyword",
    ["vbroadcastf64x4"] = "keyword",
    ["vbroadcasti128"] = "keyword",
    ["vbroadcasti32x2"] = "keyword",
    ["vbroadcasti32x4"] = "keyword",
    ["vbroadcasti32x8"] = "keyword",
    ["vbroadcasti64x2"] = "keyword",
    ["vbroadcasti64x4"] = "keyword",
    ["vbroadcastq"] = "keyword",
    ["vbroadcastsd"] = "keyword",
    ["vbroadcastss"] = "keyword",
    ["vbroadcastw"] = "keyword",
    ["vcmpeq_ospd"] = "keyword",
    ["vcmpeq_osps"] = "keyword",
    ["vcmpeq_ossd"] = "keyword",
    ["vcmpeq_osss"] = "keyword",
    ["vcmpeq_uqpd"] = "keyword",
    ["vcmpeq_uqps"] = "keyword",
    ["vcmpeq_uqsd"] = "keyword",
    ["vcmpeq_uqss"] = "keyword",
    ["vcmpeq_uspd"] = "keyword",
    ["vcmpeq_usps"] = "keyword",
    ["vcmpeq_ussd"] = "keyword",
    ["vcmpeq_usss"] = "keyword",
    ["vcmpeqpd"] = "keyword",
    ["vcmpeqps"] = "keyword",
    ["vcmpeqsd"] = "keyword",
    ["vcmpeqss"] = "keyword",
    ["vcmpfalse_oqpd"] = "keyword",
    ["vcmpfalse_oqps"] = "keyword",
    ["vcmpfalse_oqsd"] = "keyword",
    ["vcmpfalse_oqss"] = "keyword",
    ["vcmpfalse_ospd"] = "keyword",
    ["vcmpfalse_osps"] = "keyword",
    ["vcmpfalse_ossd"] = "keyword",
    ["vcmpfalse_osss"] = "keyword",
    ["vcmpfalsepd"] = "keyword",
    ["vcmpfalseps"] = "keyword",
    ["vcmpfalsesd"] = "keyword",
    ["vcmpfalsess"] = "keyword",
    ["vcmpge_oqpd"] = "keyword",
    ["vcmpge_oqps"] = "keyword",
    ["vcmpge_oqsd"] = "keyword",
    ["vcmpge_oqss"] = "keyword",
    ["vcmpge_ospd"] = "keyword",
    ["vcmpge_osps"] = "keyword",
    ["vcmpge_ossd"] = "keyword",
    ["vcmpge_osss"] = "keyword",
    ["vcmpgepd"] = "keyword",
    ["vcmpgeps"] = "keyword",
    ["vcmpgesd"] = "keyword",
    ["vcmpgess"] = "keyword",
    ["vcmpgt_oqpd"] = "keyword",
    ["vcmpgt_oqps"] = "keyword",
    ["vcmpgt_oqsd"] = "keyword",
    ["vcmpgt_oqss"] = "keyword",
    ["vcmpgt_ospd"] = "keyword",
    ["vcmpgt_osps"] = "keyword",
    ["vcmpgt_ossd"] = "keyword",
    ["vcmpgt_osss"] = "keyword",
    ["vcmpgtpd"] = "keyword",
    ["vcmpgtps"] = "keyword",
    ["vcmpgtsd"] = "keyword",
    ["vcmpgtss"] = "keyword",
    ["vcmple_oqpd"] = "keyword",
    ["vcmple_oqps"] = "keyword",
    ["vcmple_oqsd"] = "keyword",
    ["vcmple_oqss"] = "keyword",
    ["vcmple_ospd"] = "keyword",
    ["vcmple_osps"] = "keyword",
    ["vcmple_ossd"] = "keyword",
    ["vcmple_osss"] = "keyword",
    ["vcmplepd"] = "keyword",
    ["vcmpleps"] = "keyword",
    ["vcmplesd"] = "keyword",
    ["vcmpless"] = "keyword",
    ["vcmplt_oqpd"] = "keyword",
    ["vcmplt_oqps"] = "keyword",
    ["vcmplt_oqsd"] = "keyword",
    ["vcmplt_oqss"] = "keyword",
    ["vcmplt_ospd"] = "keyword",
    ["vcmplt_osps"] = "keyword",
    ["vcmplt_ossd"] = "keyword",
    ["vcmplt_osss"] = "keyword",
    ["vcmpltpd"] = "keyword",
    ["vcmpltps"] = "keyword",
    ["vcmpltsd"] = "keyword",
    ["vcmpltss"] = "keyword",
    ["vcmpneq_oqpd"] = "keyword",
    ["vcmpneq_oqps"] = "keyword",
    ["vcmpneq_oqsd"] = "keyword",
    ["vcmpneq_oqss"] = "keyword",
    ["vcmpneq_ospd"] = "keyword",
    ["vcmpneq_osps"] = "keyword",
    ["vcmpneq_ossd"] = "keyword",
    ["vcmpneq_osss"] = "keyword",
    ["vcmpneq_uqpd"] = "keyword",
    ["vcmpneq_uqps"] = "keyword",
    ["vcmpneq_uqsd"] = "keyword",
    ["vcmpneq_uqss"] = "keyword",
    ["vcmpneq_uspd"] = "keyword",
    ["vcmpneq_usps"] = "keyword",
    ["vcmpneq_ussd"] = "keyword",
    ["vcmpneq_usss"] = "keyword",
    ["vcmpneqpd"] = "keyword",
    ["vcmpneqps"] = "keyword",
    ["vcmpneqsd"] = "keyword",
    ["vcmpneqss"] = "keyword",
    ["vcmpnge_uqpd"] = "keyword",
    ["vcmpnge_uqps"] = "keyword",
    ["vcmpnge_uqsd"] = "keyword",
    ["vcmpnge_uqss"] = "keyword",
    ["vcmpnge_uspd"] = "keyword",
    ["vcmpnge_usps"] = "keyword",
    ["vcmpnge_ussd"] = "keyword",
    ["vcmpnge_usss"] = "keyword",
    ["vcmpngepd"] = "keyword",
    ["vcmpngeps"] = "keyword",
    ["vcmpngesd"] = "keyword",
    ["vcmpngess"] = "keyword",
    ["vcmpngt_uqpd"] = "keyword",
    ["vcmpngt_uqps"] = "keyword",
    ["vcmpngt_uqsd"] = "keyword",
    ["vcmpngt_uqss"] = "keyword",
    ["vcmpngt_uspd"] = "keyword",
    ["vcmpngt_usps"] = "keyword",
    ["vcmpngt_ussd"] = "keyword",
    ["vcmpngt_usss"] = "keyword",
    ["vcmpngtpd"] = "keyword",
    ["vcmpngtps"] = "keyword",
    ["vcmpngtsd"] = "keyword",
    ["vcmpngtss"] = "keyword",
    ["vcmpnle_uqpd"] = "keyword",
    ["vcmpnle_uqps"] = "keyword",
    ["vcmpnle_uqsd"] = "keyword",
    ["vcmpnle_uqss"] = "keyword",
    ["vcmpnle_uspd"] = "keyword",
    ["vcmpnle_usps"] = "keyword",
    ["vcmpnle_ussd"] = "keyword",
    ["vcmpnle_usss"] = "keyword",
    ["vcmpnlepd"] = "keyword",
    ["vcmpnleps"] = "keyword",
    ["vcmpnlesd"] = "keyword",
    ["vcmpnless"] = "keyword",
    ["vcmpnlt_uqpd"] = "keyword",
    ["vcmpnlt_uqps"] = "keyword",
    ["vcmpnlt_uqsd"] = "keyword",
    ["vcmpnlt_uqss"] = "keyword",
    ["vcmpnlt_uspd"] = "keyword",
    ["vcmpnlt_usps"] = "keyword",
    ["vcmpnlt_ussd"] = "keyword",
    ["vcmpnlt_usss"] = "keyword",
    ["vcmpnltpd"] = "keyword",
    ["vcmpnltps"] = "keyword",
    ["vcmpnltsd"] = "keyword",
    ["vcmpnltss"] = "keyword",
    ["vcmpord_qpd"] = "keyword",
    ["vcmpord_qps"] = "keyword",
    ["vcmpord_qsd"] = "keyword",
    ["vcmpord_qss"] = "keyword",
    ["vcmpord_spd"] = "keyword",
    ["vcmpord_sps"] = "keyword",
    ["vcmpord_ssd"] = "keyword",
    ["vcmpord_sss"] = "keyword",
    ["vcmpordpd"] = "keyword",
    ["vcmpordps"] = "keyword",
    ["vcmpordsd"] = "keyword",
    ["vcmpordss"] = "keyword",
    ["vcmppd"] = "keyword",
    ["vcmpps"] = "keyword",
    ["vcmpsd"] = "keyword",
    ["vcmpss"] = "keyword",
    ["vcmptrue_uqpd"] = "keyword",
    ["vcmptrue_uqps"] = "keyword",
    ["vcmptrue_uqsd"] = "keyword",
    ["vcmptrue_uqss"] = "keyword",
    ["vcmptrue_uspd"] = "keyword",
    ["vcmptrue_usps"] = "keyword",
    ["vcmptrue_ussd"] = "keyword",
    ["vcmptrue_usss"] = "keyword",
    ["vcmptruepd"] = "keyword",
    ["vcmptrueps"] = "keyword",
    ["vcmptruesd"] = "keyword",
    ["vcmptruess"] = "keyword",
    ["vcmpunord_qpd"] = "keyword",
    ["vcmpunord_qps"] = "keyword",
    ["vcmpunord_qsd"] = "keyword",
    ["vcmpunord_qss"] = "keyword",
    ["vcmpunord_spd"] = "keyword",
    ["vcmpunord_sps"] = "keyword",
    ["vcmpunord_ssd"] = "keyword",
    ["vcmpunord_sss"] = "keyword",
    ["vcmpunordpd"] = "keyword",
    ["vcmpunordps"] = "keyword",
    ["vcmpunordsd"] = "keyword",
    ["vcmpunordss"] = "keyword",
    ["vcomisd"] = "keyword",
    ["vcomiss"] = "keyword",
    ["vcompresspd"] = "keyword",
    ["vcompressps"] = "keyword",
    ["vcvtdq2pd"] = "keyword",
    ["vcvtdq2ps"] = "keyword",
    ["vcvtpd2dq"] = "keyword",
    ["vcvtpd2ps"] = "keyword",
    ["vcvtpd2qq"] = "keyword",
    ["vcvtpd2udq"] = "keyword",
    ["vcvtpd2uqq"] = "keyword",
    ["vcvtph2ps"] = "keyword",
    ["vcvtps2dq"] = "keyword",
    ["vcvtps2pd"] = "keyword",
    ["vcvtps2ph"] = "keyword",
    ["vcvtps2qq"] = "keyword",
    ["vcvtps2udq"] = "keyword",
    ["vcvtps2uqq"] = "keyword",
    ["vcvtqq2pd"] = "keyword",
    ["vcvtqq2ps"] = "keyword",
    ["vcvtsd2si"] = "keyword",
    ["vcvtsd2ss"] = "keyword",
    ["vcvtsd2usi"] = "keyword",
    ["vcvtsi2sd"] = "keyword",
    ["vcvtsi2ss"] = "keyword",
    ["vcvtss2sd"] = "keyword",
    ["vcvtss2si"] = "keyword",
    ["vcvtss2usi"] = "keyword",
    ["vcvttpd2dq"] = "keyword",
    ["vcvttpd2qq"] = "keyword",
    ["vcvttpd2udq"] = "keyword",
    ["vcvttpd2uqq"] = "keyword",
    ["vcvttps2dq"] = "keyword",
    ["vcvttps2qq"] = "keyword",
    ["vcvttps2udq"] = "keyword",
    ["vcvttps2uqq"] = "keyword",
    ["vcvttsd2si"] = "keyword",
    ["vcvttsd2usi"] = "keyword",
    ["vcvttss2si"] = "keyword",
    ["vcvttss2usi"] = "keyword",
    ["vcvtudq2pd"] = "keyword",
    ["vcvtudq2ps"] = "keyword",
    ["vcvtuqq2pd"] = "keyword",
    ["vcvtuqq2ps"] = "keyword",
    ["vcvtusi2sd"] = "keyword",
    ["vcvtusi2ss"] = "keyword",
    ["vdbpsadbw"] = "keyword",
    ["vdivpd"] = "keyword",
    ["vdivps"] = "keyword",
    ["vdivsd"] = "keyword",
    ["vdivss"] = "keyword",
    ["vdppd"] = "keyword",
    ["vdpps"] = "keyword",
    ["verr"] = "keyword",
    ["verw"] = "keyword",
    ["vexp2pd"] = "keyword",
    ["vexp2ps"] = "keyword",
    ["vexpandpd"] = "keyword",
    ["vexpandps"] = "keyword",
    ["vextractf128"] = "keyword",
    ["vextractf32x4"] = "keyword",
    ["vextractf32x8"] = "keyword",
    ["vextractf64x2"] = "keyword",
    ["vextractf64x4"] = "keyword",
    ["vextracti128"] = "keyword",
    ["vextracti32x4"] = "keyword",
    ["vextracti32x8"] = "keyword",
    ["vextracti64x2"] = "keyword",
    ["vextracti64x4"] = "keyword",
    ["vextractps"] = "keyword",
    ["vfixupimmpd"] = "keyword",
    ["vfixupimmps"] = "keyword",
    ["vfixupimmsd"] = "keyword",
    ["vfixupimmss"] = "keyword",
    ["vfmadd123pd"] = "keyword",
    ["vfmadd123ps"] = "keyword",
    ["vfmadd123sd"] = "keyword",
    ["vfmadd123ss"] = "keyword",
    ["vfmadd132pd"] = "keyword",
    ["vfmadd132ps"] = "keyword",
    ["vfmadd132sd"] = "keyword",
    ["vfmadd132ss"] = "keyword",
    ["vfmadd213pd"] = "keyword",
    ["vfmadd213ps"] = "keyword",
    ["vfmadd213sd"] = "keyword",
    ["vfmadd213ss"] = "keyword",
    ["vfmadd231pd"] = "keyword",
    ["vfmadd231ps"] = "keyword",
    ["vfmadd231sd"] = "keyword",
    ["vfmadd231ss"] = "keyword",
    ["vfmadd312pd"] = "keyword",
    ["vfmadd312ps"] = "keyword",
    ["vfmadd312sd"] = "keyword",
    ["vfmadd312ss"] = "keyword",
    ["vfmadd321pd"] = "keyword",
    ["vfmadd321ps"] = "keyword",
    ["vfmadd321sd"] = "keyword",
    ["vfmadd321ss"] = "keyword",
    ["vfmaddpd"] = "keyword",
    ["vfmaddps"] = "keyword",
    ["vfmaddsd"] = "keyword",
    ["vfmaddss"] = "keyword",
    ["vfmaddsub123pd"] = "keyword",
    ["vfmaddsub123ps"] = "keyword",
    ["vfmaddsub132pd"] = "keyword",
    ["vfmaddsub132ps"] = "keyword",
    ["vfmaddsub213pd"] = "keyword",
    ["vfmaddsub213ps"] = "keyword",
    ["vfmaddsub231pd"] = "keyword",
    ["vfmaddsub231ps"] = "keyword",
    ["vfmaddsub312pd"] = "keyword",
    ["vfmaddsub312ps"] = "keyword",
    ["vfmaddsub321pd"] = "keyword",
    ["vfmaddsub321ps"] = "keyword",
    ["vfmaddsubpd"] = "keyword",
    ["vfmaddsubps"] = "keyword",
    ["vfmsub123pd"] = "keyword",
    ["vfmsub123ps"] = "keyword",
    ["vfmsub123sd"] = "keyword",
    ["vfmsub123ss"] = "keyword",
    ["vfmsub132pd"] = "keyword",
    ["vfmsub132ps"] = "keyword",
    ["vfmsub132sd"] = "keyword",
    ["vfmsub132ss"] = "keyword",
    ["vfmsub213pd"] = "keyword",
    ["vfmsub213ps"] = "keyword",
    ["vfmsub213sd"] = "keyword",
    ["vfmsub213ss"] = "keyword",
    ["vfmsub231pd"] = "keyword",
    ["vfmsub231ps"] = "keyword",
    ["vfmsub231sd"] = "keyword",
    ["vfmsub231ss"] = "keyword",
    ["vfmsub312pd"] = "keyword",
    ["vfmsub312ps"] = "keyword",
    ["vfmsub312sd"] = "keyword",
    ["vfmsub312ss"] = "keyword",
    ["vfmsub321pd"] = "keyword",
    ["vfmsub321ps"] = "keyword",
    ["vfmsub321sd"] = "keyword",
    ["vfmsub321ss"] = "keyword",
    ["vfmsubadd123pd"] = "keyword",
    ["vfmsubadd123ps"] = "keyword",
    ["vfmsubadd132pd"] = "keyword",
    ["vfmsubadd132ps"] = "keyword",
    ["vfmsubadd213pd"] = "keyword",
    ["vfmsubadd213ps"] = "keyword",
    ["vfmsubadd231pd"] = "keyword",
    ["vfmsubadd231ps"] = "keyword",
    ["vfmsubadd312pd"] = "keyword",
    ["vfmsubadd312ps"] = "keyword",
    ["vfmsubadd321pd"] = "keyword",
    ["vfmsubadd321ps"] = "keyword",
    ["vfmsubaddpd"] = "keyword",
    ["vfmsubaddps"] = "keyword",
    ["vfmsubpd"] = "keyword",
    ["vfmsubps"] = "keyword",
    ["vfmsubsd"] = "keyword",
    ["vfmsubss"] = "keyword",
    ["vfnmadd123pd"] = "keyword",
    ["vfnmadd123ps"] = "keyword",
    ["vfnmadd123sd"] = "keyword",
    ["vfnmadd123ss"] = "keyword",
    ["vfnmadd132pd"] = "keyword",
    ["vfnmadd132ps"] = "keyword",
    ["vfnmadd132sd"] = "keyword",
    ["vfnmadd132ss"] = "keyword",
    ["vfnmadd213pd"] = "keyword",
    ["vfnmadd213ps"] = "keyword",
    ["vfnmadd213sd"] = "keyword",
    ["vfnmadd213ss"] = "keyword",
    ["vfnmadd231pd"] = "keyword",
    ["vfnmadd231ps"] = "keyword",
    ["vfnmadd231sd"] = "keyword",
    ["vfnmadd231ss"] = "keyword",
    ["vfnmadd312pd"] = "keyword",
    ["vfnmadd312ps"] = "keyword",
    ["vfnmadd312sd"] = "keyword",
    ["vfnmadd312ss"] = "keyword",
    ["vfnmadd321pd"] = "keyword",
    ["vfnmadd321ps"] = "keyword",
    ["vfnmadd321sd"] = "keyword",
    ["vfnmadd321ss"] = "keyword",
    ["vfnmaddpd"] = "keyword",
    ["vfnmaddps"] = "keyword",
    ["vfnmaddsd"] = "keyword",
    ["vfnmaddss"] = "keyword",
    ["vfnmsub123pd"] = "keyword",
    ["vfnmsub123ps"] = "keyword",
    ["vfnmsub123sd"] = "keyword",
    ["vfnmsub123ss"] = "keyword",
    ["vfnmsub132pd"] = "keyword",
    ["vfnmsub132ps"] = "keyword",
    ["vfnmsub132sd"] = "keyword",
    ["vfnmsub132ss"] = "keyword",
    ["vfnmsub213pd"] = "keyword",
    ["vfnmsub213ps"] = "keyword",
    ["vfnmsub213sd"] = "keyword",
    ["vfnmsub213ss"] = "keyword",
    ["vfnmsub231pd"] = "keyword",
    ["vfnmsub231ps"] = "keyword",
    ["vfnmsub231sd"] = "keyword",
    ["vfnmsub231ss"] = "keyword",
    ["vfnmsub312pd"] = "keyword",
    ["vfnmsub312ps"] = "keyword",
    ["vfnmsub312sd"] = "keyword",
    ["vfnmsub312ss"] = "keyword",
    ["vfnmsub321pd"] = "keyword",
    ["vfnmsub321ps"] = "keyword",
    ["vfnmsub321sd"] = "keyword",
    ["vfnmsub321ss"] = "keyword",
    ["vfnmsubpd"] = "keyword",
    ["vfnmsubps"] = "keyword",
    ["vfnmsubsd"] = "keyword",
    ["vfnmsubss"] = "keyword",
    ["vfpclasspd"] = "keyword",
    ["vfpclassps"] = "keyword",
    ["vfpclasssd"] = "keyword",
    ["vfpclassss"] = "keyword",
    ["vfrczpd"] = "keyword",
    ["vfrczps"] = "keyword",
    ["vfrczsd"] = "keyword",
    ["vfrczss"] = "keyword",
    ["vgatherdd"] = "keyword",
    ["vgatherdpd"] = "keyword",
    ["vgatherdps"] = "keyword",
    ["vgatherdq"] = "keyword",
    ["vgatherpf0dpd"] = "keyword",
    ["vgatherpf0dps"] = "keyword",
    ["vgatherpf0qpd"] = "keyword",
    ["vgatherpf0qps"] = "keyword",
    ["vgatherpf1dpd"] = "keyword",
    ["vgatherpf1dps"] = "keyword",
    ["vgatherpf1qpd"] = "keyword",
    ["vgatherpf1qps"] = "keyword",
    ["vgatherqd"] = "keyword",
    ["vgatherqpd"] = "keyword",
    ["vgatherqps"] = "keyword",
    ["vgatherqq"] = "keyword",
    ["vgetexppd"] = "keyword",
    ["vgetexpps"] = "keyword",
    ["vgetexpsd"] = "keyword",
    ["vgetexpss"] = "keyword",
    ["vgetmantpd"] = "keyword",
    ["vgetmantps"] = "keyword",
    ["vgetmantsd"] = "keyword",
    ["vgetmantss"] = "keyword",
    ["vhaddpd"] = "keyword",
    ["vhaddps"] = "keyword",
    ["vhsubpd"] = "keyword",
    ["vhsubps"] = "keyword",
    ["vinsertf128"] = "keyword",
    ["vinsertf32x4"] = "keyword",
    ["vinsertf32x8"] = "keyword",
    ["vinsertf64x2"] = "keyword",
    ["vinsertf64x4"] = "keyword",
    ["vinserti128"] = "keyword",
    ["vinserti32x4"] = "keyword",
    ["vinserti32x8"] = "keyword",
    ["vinserti64x2"] = "keyword",
    ["vinserti64x4"] = "keyword",
    ["vinsertps"] = "keyword",
    ["vlddqu"] = "keyword",
    ["vldmxcsr"] = "keyword",
    ["vldqqu"] = "keyword",
    ["vmaskmovd"] = "keyword",
    ["vmaskmovdqu"] = "keyword",
    ["vmaskmovpd"] = "keyword",
    ["vmaskmovps"] = "keyword",
    ["vmaskmovq"] = "keyword",
    ["vmaxpd"] = "keyword",
    ["vmaxps"] = "keyword",
    ["vmaxsd"] = "keyword",
    ["vmaxss"] = "keyword",
    ["vmcall"] = "keyword",
    ["vmclear"] = "keyword",
    ["vmfunc"] = "keyword",
    ["vminpd"] = "keyword",
    ["vminps"] = "keyword",
    ["vminsd"] = "keyword",
    ["vminss"] = "keyword",
    ["vmlaunch"] = "keyword",
    ["vmload"] = "keyword",
    ["vmmcall"] = "keyword",
    ["vmovapd"] = "keyword",
    ["vmovaps"] = "keyword",
    ["vmovd"] = "keyword",
    ["vmovddup"] = "keyword",
    ["vmovdqa"] = "keyword",
    ["vmovdqa32"] = "keyword",
    ["vmovdqa64"] = "keyword",
    ["vmovdqu"] = "keyword",
    ["vmovdqu16"] = "keyword",
    ["vmovdqu32"] = "keyword",
    ["vmovdqu64"] = "keyword",
    ["vmovdqu8"] = "keyword",
    ["vmovhlps"] = "keyword",
    ["vmovhpd"] = "keyword",
    ["vmovhps"] = "keyword",
    ["vmovlhps"] = "keyword",
    ["vmovlpd"] = "keyword",
    ["vmovlps"] = "keyword",
    ["vmovmskpd"] = "keyword",
    ["vmovmskps"] = "keyword",
    ["vmovntdq"] = "keyword",
    ["vmovntdqa"] = "keyword",
    ["vmovntpd"] = "keyword",
    ["vmovntps"] = "keyword",
    ["vmovntqq"] = "keyword",
    ["vmovq"] = "keyword",
    ["vmovqqa"] = "keyword",
    ["vmovqqu"] = "keyword",
    ["vmovsd"] = "keyword",
    ["vmovshdup"] = "keyword",
    ["vmovsldup"] = "keyword",
    ["vmovss"] = "keyword",
    ["vmovupd"] = "keyword",
    ["vmovups"] = "keyword",
    ["vmpsadbw"] = "keyword",
    ["vmptrld"] = "keyword",
    ["vmptrst"] = "keyword",
    ["vmread"] = "keyword",
    ["vmresume"] = "keyword",
    ["vmrun"] = "keyword",
    ["vmsave"] = "keyword",
    ["vmulpd"] = "keyword",
    ["vmulps"] = "keyword",
    ["vmulsd"] = "keyword",
    ["vmulss"] = "keyword",
    ["vmwrite"] = "keyword",
    ["vmxoff"] = "keyword",
    ["vmxon"] = "keyword",
    ["vorpd"] = "keyword",
    ["vorps"] = "keyword",
    ["vpabsb"] = "keyword",
    ["vpabsd"] = "keyword",
    ["vpabsq"] = "keyword",
    ["vpabsw"] = "keyword",
    ["vpackssdw"] = "keyword",
    ["vpacksswb"] = "keyword",
    ["vpackusdw"] = "keyword",
    ["vpackuswb"] = "keyword",
    ["vpaddb"] = "keyword",
    ["vpaddd"] = "keyword",
    ["vpaddq"] = "keyword",
    ["vpaddsb"] = "keyword",
    ["vpaddsw"] = "keyword",
    ["vpaddusb"] = "keyword",
    ["vpaddusw"] = "keyword",
    ["vpaddw"] = "keyword",
    ["vpalignr"] = "keyword",
    ["vpand"] = "keyword",
    ["vpandd"] = "keyword",
    ["vpandn"] = "keyword",
    ["vpandnd"] = "keyword",
    ["vpandnq"] = "keyword",
    ["vpandq"] = "keyword",
    ["vpavgb"] = "keyword",
    ["vpavgw"] = "keyword",
    ["vpblendd"] = "keyword",
    ["vpblendmb"] = "keyword",
    ["vpblendmd"] = "keyword",
    ["vpblendmq"] = "keyword",
    ["vpblendmw"] = "keyword",
    ["vpblendvb"] = "keyword",
    ["vpblendw"] = "keyword",
    ["vpbroadcastb"] = "keyword",
    ["vpbroadcastd"] = "keyword",
    ["vpbroadcastmb2q"] = "keyword",
    ["vpbroadcastmw2d"] = "keyword",
    ["vpbroadcastq"] = "keyword",
    ["vpbroadcastw"] = "keyword",
    ["vpclmulhqhqdq"] = "keyword",
    ["vpclmulhqlqdq"] = "keyword",
    ["vpclmullqhqdq"] = "keyword",
    ["vpclmullqlqdq"] = "keyword",
    ["vpclmulqdq"] = "keyword",
    ["vpcmov"] = "keyword",
    ["vpcmpb"] = "keyword",
    ["vpcmpd"] = "keyword",
    ["vpcmpeqb"] = "keyword",
    ["vpcmpeqd"] = "keyword",
    ["vpcmpeqq"] = "keyword",
    ["vpcmpeqw"] = "keyword",
    ["vpcmpestri"] = "keyword",
    ["vpcmpestrm"] = "keyword",
    ["vpcmpgtb"] = "keyword",
    ["vpcmpgtd"] = "keyword",
    ["vpcmpgtq"] = "keyword",
    ["vpcmpgtw"] = "keyword",
    ["vpcmpistri"] = "keyword",
    ["vpcmpistrm"] = "keyword",
    ["vpcmpq"] = "keyword",
    ["vpcmpub"] = "keyword",
    ["vpcmpud"] = "keyword",
    ["vpcmpuq"] = "keyword",
    ["vpcmpuw"] = "keyword",
    ["vpcmpw"] = "keyword",
    ["vpcomb"] = "keyword",
    ["vpcomd"] = "keyword",
    ["vpcompressd"] = "keyword",
    ["vpcompressq"] = "keyword",
    ["vpcomq"] = "keyword",
    ["vpcomub"] = "keyword",
    ["vpcomud"] = "keyword",
    ["vpcomuq"] = "keyword",
    ["vpcomuw"] = "keyword",
    ["vpcomw"] = "keyword",
    ["vpconflictd"] = "keyword",
    ["vpconflictq"] = "keyword",
    ["vperm2f128"] = "keyword",
    ["vperm2i128"] = "keyword",
    ["vpermb"] = "keyword",
    ["vpermd"] = "keyword",
    ["vpermi2b"] = "keyword",
    ["vpermi2d"] = "keyword",
    ["vpermi2pd"] = "keyword",
    ["vpermi2ps"] = "keyword",
    ["vpermi2q"] = "keyword",
    ["vpermi2w"] = "keyword",
    ["vpermilpd"] = "keyword",
    ["vpermilps"] = "keyword",
    ["vpermpd"] = "keyword",
    ["vpermps"] = "keyword",
    ["vpermq"] = "keyword",
    ["vpermt2b"] = "keyword",
    ["vpermt2d"] = "keyword",
    ["vpermt2pd"] = "keyword",
    ["vpermt2ps"] = "keyword",
    ["vpermt2q"] = "keyword",
    ["vpermt2w"] = "keyword",
    ["vpermw"] = "keyword",
    ["vpexpandd"] = "keyword",
    ["vpexpandq"] = "keyword",
    ["vpextrb"] = "keyword",
    ["vpextrd"] = "keyword",
    ["vpextrq"] = "keyword",
    ["vpextrw"] = "keyword",
    ["vpgatherdd"] = "keyword",
    ["vpgatherdq"] = "keyword",
    ["vpgatherqd"] = "keyword",
    ["vpgatherqq"] = "keyword",
    ["vphaddbd"] = "keyword",
    ["vphaddbq"] = "keyword",
    ["vphaddbw"] = "keyword",
    ["vphaddd"] = "keyword",
    ["vphadddq"] = "keyword",
    ["vphaddsw"] = "keyword",
    ["vphaddubd"] = "keyword",
    ["vphaddubq"] = "keyword",
    ["vphaddubw"] = "keyword",
    ["vphaddudq"] = "keyword",
    ["vphadduwd"] = "keyword",
    ["vphadduwq"] = "keyword",
    ["vphaddw"] = "keyword",
    ["vphaddwd"] = "keyword",
    ["vphaddwq"] = "keyword",
    ["vphminposuw"] = "keyword",
    ["vphsubbw"] = "keyword",
    ["vphsubd"] = "keyword",
    ["vphsubdq"] = "keyword",
    ["vphsubsw"] = "keyword",
    ["vphsubw"] = "keyword",
    ["vphsubwd"] = "keyword",
    ["vpinsrb"] = "keyword",
    ["vpinsrd"] = "keyword",
    ["vpinsrq"] = "keyword",
    ["vpinsrw"] = "keyword",
    ["vplzcntd"] = "keyword",
    ["vplzcntq"] = "keyword",
    ["vpmacsdd"] = "keyword",
    ["vpmacsdqh"] = "keyword",
    ["vpmacsdql"] = "keyword",
    ["vpmacssdd"] = "keyword",
    ["vpmacssdqh"] = "keyword",
    ["vpmacssdql"] = "keyword",
    ["vpmacsswd"] = "keyword",
    ["vpmacssww"] = "keyword",
    ["vpmacswd"] = "keyword",
    ["vpmacsww"] = "keyword",
    ["vpmadcsswd"] = "keyword",
    ["vpmadcswd"] = "keyword",
    ["vpmadd52huq"] = "keyword",
    ["vpmadd52luq"] = "keyword",
    ["vpmaddubsw"] = "keyword",
    ["vpmaddwd"] = "keyword",
    ["vpmaskmovd"] = "keyword",
    ["vpmaskmovq"] = "keyword",
    ["vpmaxsb"] = "keyword",
    ["vpmaxsd"] = "keyword",
    ["vpmaxsq"] = "keyword",
    ["vpmaxsw"] = "keyword",
    ["vpmaxub"] = "keyword",
    ["vpmaxud"] = "keyword",
    ["vpmaxuq"] = "keyword",
    ["vpmaxuw"] = "keyword",
    ["vpminsb"] = "keyword",
    ["vpminsd"] = "keyword",
    ["vpminsq"] = "keyword",
    ["vpminsw"] = "keyword",
    ["vpminub"] = "keyword",
    ["vpminud"] = "keyword",
    ["vpminuq"] = "keyword",
    ["vpminuw"] = "keyword",
    ["vpmovb2m"] = "keyword",
    ["vpmovd2m"] = "keyword",
    ["vpmovdb"] = "keyword",
    ["vpmovdw"] = "keyword",
    ["vpmovm2b"] = "keyword",
    ["vpmovm2d"] = "keyword",
    ["vpmovm2q"] = "keyword",
    ["vpmovm2w"] = "keyword",
    ["vpmovmskb"] = "keyword",
    ["vpmovq2m"] = "keyword",
    ["vpmovqb"] = "keyword",
    ["vpmovqd"] = "keyword",
    ["vpmovqw"] = "keyword",
    ["vpmovsdb"] = "keyword",
    ["vpmovsdw"] = "keyword",
    ["vpmovsqb"] = "keyword",
    ["vpmovsqd"] = "keyword",
    ["vpmovsqw"] = "keyword",
    ["vpmovswb"] = "keyword",
    ["vpmovsxbd"] = "keyword",
    ["vpmovsxbq"] = "keyword",
    ["vpmovsxbw"] = "keyword",
    ["vpmovsxdq"] = "keyword",
    ["vpmovsxwd"] = "keyword",
    ["vpmovsxwq"] = "keyword",
    ["vpmovusdb"] = "keyword",
    ["vpmovusdw"] = "keyword",
    ["vpmovusqb"] = "keyword",
    ["vpmovusqd"] = "keyword",
    ["vpmovusqw"] = "keyword",
    ["vpmovuswb"] = "keyword",
    ["vpmovw2m"] = "keyword",
    ["vpmovwb"] = "keyword",
    ["vpmovzxbd"] = "keyword",
    ["vpmovzxbq"] = "keyword",
    ["vpmovzxbw"] = "keyword",
    ["vpmovzxdq"] = "keyword",
    ["vpmovzxwd"] = "keyword",
    ["vpmovzxwq"] = "keyword",
    ["vpmuldq"] = "keyword",
    ["vpmulhrsw"] = "keyword",
    ["vpmulhuw"] = "keyword",
    ["vpmulhw"] = "keyword",
    ["vpmulld"] = "keyword",
    ["vpmullq"] = "keyword",
    ["vpmullw"] = "keyword",
    ["vpmultishiftqb"] = "keyword",
    ["vpmuludq"] = "keyword",
    ["vpor"] = "keyword",
    ["vpord"] = "keyword",
    ["vporq"] = "keyword",
    ["vpperm"] = "keyword",
    ["vprold"] = "keyword",
    ["vprolq"] = "keyword",
    ["vprolvd"] = "keyword",
    ["vprolvq"] = "keyword",
    ["vprord"] = "keyword",
    ["vprorq"] = "keyword",
    ["vprorvd"] = "keyword",
    ["vprorvq"] = "keyword",
    ["vprotb"] = "keyword",
    ["vprotd"] = "keyword",
    ["vprotq"] = "keyword",
    ["vprotw"] = "keyword",
    ["vpsadbw"] = "keyword",
    ["vpscatterdd"] = "keyword",
    ["vpscatterdq"] = "keyword",
    ["vpscatterqd"] = "keyword",
    ["vpscatterqq"] = "keyword",
    ["vpshab"] = "keyword",
    ["vpshad"] = "keyword",
    ["vpshaq"] = "keyword",
    ["vpshaw"] = "keyword",
    ["vpshlb"] = "keyword",
    ["vpshld"] = "keyword",
    ["vpshlq"] = "keyword",
    ["vpshlw"] = "keyword",
    ["vpshufb"] = "keyword",
    ["vpshufd"] = "keyword",
    ["vpshufhw"] = "keyword",
    ["vpshuflw"] = "keyword",
    ["vpsignb"] = "keyword",
    ["vpsignd"] = "keyword",
    ["vpsignw"] = "keyword",
    ["vpslld"] = "keyword",
    ["vpslldq"] = "keyword",
    ["vpsllq"] = "keyword",
    ["vpsllvd"] = "keyword",
    ["vpsllvq"] = "keyword",
    ["vpsllvw"] = "keyword",
    ["vpsllw"] = "keyword",
    ["vpsrad"] = "keyword",
    ["vpsraq"] = "keyword",
    ["vpsravd"] = "keyword",
    ["vpsravq"] = "keyword",
    ["vpsravw"] = "keyword",
    ["vpsraw"] = "keyword",
    ["vpsrld"] = "keyword",
    ["vpsrldq"] = "keyword",
    ["vpsrlq"] = "keyword",
    ["vpsrlvd"] = "keyword",
    ["vpsrlvq"] = "keyword",
    ["vpsrlvw"] = "keyword",
    ["vpsrlw"] = "keyword",
    ["vpsubb"] = "keyword",
    ["vpsubd"] = "keyword",
    ["vpsubq"] = "keyword",
    ["vpsubsb"] = "keyword",
    ["vpsubsw"] = "keyword",
    ["vpsubusb"] = "keyword",
    ["vpsubusw"] = "keyword",
    ["vpsubw"] = "keyword",
    ["vpternlogd"] = "keyword",
    ["vpternlogq"] = "keyword",
    ["vptest"] = "keyword",
    ["vptestmb"] = "keyword",
    ["vptestmd"] = "keyword",
    ["vptestmq"] = "keyword",
    ["vptestmw"] = "keyword",
    ["vptestnmb"] = "keyword",
    ["vptestnmd"] = "keyword",
    ["vptestnmq"] = "keyword",
    ["vptestnmw"] = "keyword",
    ["vpunpckhbw"] = "keyword",
    ["vpunpckhdq"] = "keyword",
    ["vpunpckhqdq"] = "keyword",
    ["vpunpckhwd"] = "keyword",
    ["vpunpcklbw"] = "keyword",
    ["vpunpckldq"] = "keyword",
    ["vpunpcklqdq"] = "keyword",
    ["vpunpcklwd"] = "keyword",
    ["vpxor"] = "keyword",
    ["vpxord"] = "keyword",
    ["vpxorq"] = "keyword",
    ["vrangepd"] = "keyword",
    ["vrangeps"] = "keyword",
    ["vrangesd"] = "keyword",
    ["vrangess"] = "keyword",
    ["vrcp14pd"] = "keyword",
    ["vrcp14ps"] = "keyword",
    ["vrcp14sd"] = "keyword",
    ["vrcp14ss"] = "keyword",
    ["vrcp28pd"] = "keyword",
    ["vrcp28ps"] = "keyword",
    ["vrcp28sd"] = "keyword",
    ["vrcp28ss"] = "keyword",
    ["vrcpps"] = "keyword",
    ["vrcpss"] = "keyword",
    ["vreducepd"] = "keyword",
    ["vreduceps"] = "keyword",
    ["vreducesd"] = "keyword",
    ["vreducess"] = "keyword",
    ["vrndscalepd"] = "keyword",
    ["vrndscaleps"] = "keyword",
    ["vrndscalesd"] = "keyword",
    ["vrndscaless"] = "keyword",
    ["vroundpd"] = "keyword",
    ["vroundps"] = "keyword",
    ["vroundsd"] = "keyword",
    ["vroundss"] = "keyword",
    ["vrsqrt14pd"] = "keyword",
    ["vrsqrt14ps"] = "keyword",
    ["vrsqrt14sd"] = "keyword",
    ["vrsqrt14ss"] = "keyword",
    ["vrsqrt28pd"] = "keyword",
    ["vrsqrt28ps"] = "keyword",
    ["vrsqrt28sd"] = "keyword",
    ["vrsqrt28ss"] = "keyword",
    ["vrsqrtps"] = "keyword",
    ["vrsqrtss"] = "keyword",
    ["vscalefpd"] = "keyword",
    ["vscalefps"] = "keyword",
    ["vscalefsd"] = "keyword",
    ["vscalefss"] = "keyword",
    ["vscatterdpd"] = "keyword",
    ["vscatterdps"] = "keyword",
    ["vscatterpf0dpd"] = "keyword",
    ["vscatterpf0dps"] = "keyword",
    ["vscatterpf0qpd"] = "keyword",
    ["vscatterpf0qps"] = "keyword",
    ["vscatterpf1dpd"] = "keyword",
    ["vscatterpf1dps"] = "keyword",
    ["vscatterpf1qpd"] = "keyword",
    ["vscatterpf1qps"] = "keyword",
    ["vscatterqpd"] = "keyword",
    ["vscatterqps"] = "keyword",
    ["vshuff32x4"] = "keyword",
    ["vshuff64x2"] = "keyword",
    ["vshufi32x4"] = "keyword",
    ["vshufi64x2"] = "keyword",
    ["vshufpd"] = "keyword",
    ["vshufps"] = "keyword",
    ["vsqrtpd"] = "keyword",
    ["vsqrtps"] = "keyword",
    ["vsqrtsd"] = "keyword",
    ["vsqrtss"] = "keyword",
    ["vstmxcsr"] = "keyword",
    ["vsubpd"] = "keyword",
    ["vsubps"] = "keyword",
    ["vsubsd"] = "keyword",
    ["vsubss"] = "keyword",
    ["vtestpd"] = "keyword",
    ["vtestps"] = "keyword",
    ["vucomisd"] = "keyword",
    ["vucomiss"] = "keyword",
    ["vunpckhpd"] = "keyword",
    ["vunpckhps"] = "keyword",
    ["vunpcklpd"] = "keyword",
    ["vunpcklps"] = "keyword",
    ["vxorpd"] = "keyword",
    ["vxorps"] = "keyword",
    ["vzeroall"] = "keyword",
    ["vzeroupper"] = "keyword",
    ["wait"] = "keyword",
    ["wbinvd"] = "keyword",
    ["wrfsbase"] = "keyword",
    ["wrgsbase"] = "keyword",
    ["wrmsr"] = "keyword",
    ["wrpkru"] = "keyword",
    ["wrshr"] = "keyword",
    ["xabort"] = "keyword",
    ["xadd"] = "keyword",
    ["xbegin"] = "keyword",
    ["xbts"] = "keyword",
    ["xchg"] = "keyword",
    ["xcryptcbc"] = "keyword",
    ["xcryptcfb"] = "keyword",
    ["xcryptctr"] = "keyword",
    ["xcryptecb"] = "keyword",
    ["xcryptofb"] = "keyword",
    ["xend"] = "keyword",
    ["xgetbv"] = "keyword",
    ["xlat"] = "keyword",
    ["xlatb"] = "keyword",
    ["xor"] = "keyword",
    ["xorpd"] = "keyword",
    ["xorps"] = "keyword",
    ["xrstor"] = "keyword",
    ["xrstor64"] = "keyword",
    ["xrstors"] = "keyword",
    ["xrstors64"] = "keyword",
    ["xsave"] = "keyword",
    ["xsave64"] = "keyword",
    ["xsavec"] = "keyword",
    ["xsavec64"] = "keyword",
    ["xsaveopt"] = "keyword",
    ["xsaveopt64"] = "keyword",
    ["xsaves"] = "keyword",
    ["xsaves64"] = "keyword",
    ["xsetbv"] = "keyword",
    ["xsha1"] = "keyword",
    ["xsha256"] = "keyword",
    ["xstore"] = "keyword",
    ["xtest"] = "keyword",

    -- Data
    ["times"] = "keyword2",
    ["equ"] = "keyword2",
    ["db"] = "keyword2",
    ["dw"] = "keyword2",
    ["dd"] = "keyword2",
    ["dq"] = "keyword2",
    ["dt"] = "keyword2",
    ["do"] = "keyword2",
    ["dy"] = "keyword2",
    ["dz"] = "keyword2",
    ["resb"] = "keyword2",
    ["resw"] = "keyword2",
    ["resd"] = "keyword2",
    ["resq"] = "keyword2",
    ["rest"] = "keyword2",
    ["reso"] = "keyword2",
    ["resy"] = "keyword2",
    ["resz"] = "keyword2",
    ["incbin"] = "keyword2",
    ["byte"] = "keyword2",
    ["word"] = "keyword2",
    ["dword"] = "keyword2",
    ["qword"] = "keyword2",
    ["short"] = "keyword2",
    ["ptr"] = "keyword2",
    ["tword"] = "keyword2",
    ["yword"] = "keyword2",
    ["zword"] = "keyword2",
    ["oword"] = "keyword2",

    -- NASM directives
    ["absolute"] = "keyword2", ["ABSOLUTE"] = "keyword2",
    ["bits"] = "keyword2", ["BITS"] = "keyword2",
    ["common"] = "keyword2", ["COMMON"] = "keyword2",
    ["extern"] = "keyword2", ["EXTERN"] = "keyword2",
    ["global"] = "keyword2", ["GLOBAL"] = "keyword2",
    ["org"] = "keyword2", ["ORG"] = "keyword2",
    ["section"] = "keyword2", ["SECTION"] = "keyword2",
    ["seg"] = "keyword2", ["SEG"] = "keyword2",
    ["segment"] = "keyword2", ["SEGMENT"] = "keyword2",
    ["strict"] = "keyword2", ["STRICT"] = "keyword2",
    ["use16"] = "keyword2", ["USE16"] = "keyword2",
    ["use32"] = "keyword2", ["USE32"] = "keyword2",
    ["use64"] = "keyword2", ["USE64"] = "keyword2",
    ["..got"] = "keyword2",
    ["..plt"] = "keyword2",
    ["..sym"] = "keyword2",
    ["wrt"] = "keyword2",
    ["struc"] = "keyword2",
    ["endstruc"] = "keyword2",
    ["istruc"] = "keyword2",
    ["at"] = "keyword2", ["AT"] = "keyword2",
    ["iend"] = "keyword2", ["IEND"] = "keyword2",
    ["align"] = "keyword2", ["ALIGN"] = "keyword2",
    ["alignb"] = "keyword2", ["ALIGNB"] = "keyword2",
    ["__SECT__"] = "keyword2",
    ["__NASM_MAJOR__"] = "keyword2",
    ["__NASM_MINOR__"] = "keyword2",
    ["__NASM_SUBMINOR__"] = "keyword2",
    ["___NASM_PATCHLEVEL__"] = "keyword2",
    ["__NASM_VERSION_ID__"] = "keyword2",
    ["__NASM_VER__"] = "keyword2",
    ["__FILE__"] = "keyword2",
    ["__LINE__"] = "keyword2",
    ["__BITS__"] = "keyword2",
    ["default"] = "keyword2", ["DEFAULT"] = "keyword2",
  },
}
